﻿
$(document).ready(function () {
    searchWordEvent();
});

var wordPerformanceFilter = [];
var originalWordPerformanceData = [];
var isSearchWordsText = false;
function renderTextHighlightsWordPerformanceWidget(wordsPerformance) {
    wordPerformanceBackup = wordsPerformance;
    if (!isSearchWordsText) {
        originalWordPerformanceData = wordsPerformance;
    }

    var table = $("<table>").addClass("compact dataTable no-footer").addClass("word-table");
    if (wordsPerformance != null && wordsPerformance.length > 0) {
        for (var index = 0; index < wordsPerformance.length; index++) {
            var word = wordsPerformance[index]['Words'];
            var total = wordsPerformance[index]['TotalHighlightsCounts'];
            var progressbar = $("<div>");
            var rpsContent = 0;

            if (wordsPerformance[index].TextHighlightWordPerformanceDataList.length > 0) {
                $.each(wordsPerformance[index].TextHighlightWordPerformanceDataList, function () {
                    rpsContent = this.RpsContent;
                    var categoryColor = this.CategoryColor;
                    var categoryCount = this.CategoryCount;
                    var progressWidthPercentage = (categoryCount / total) * 100 + "%";
                    progressbar.append($("<div>").addClass("proportion").attr("style", "background:" + categoryColor + ";").attr("title", categoryCount).width(progressWidthPercentage));
                });
            }

            var iconAndLabel = getTopicType(total);
            var row = "";
            row = $("<tr>");
            var createCheckBox = $("<input type='checkbox' id='displayWidgetsForSelectedWord'>");
            createCheckBox.attr("data", word);
            createCheckBox.attr("data-id", rpsContent);

            var addCheckBoxForWords = $("<td>").append(createCheckBox);
            var nameCell = $("<td>").addClass("word-name").append(word);
            var typeCell = $("<td>").addClass("word-type").append(iconAndLabel);
            var progressCell = $("<td>").addClass("word-progress")
                .append($("<div>").addClass("word-performance-proportions")
                    .append(progressbar));

            row.append(addCheckBoxForWords)
                .append(nameCell)
                .append(typeCell)
                .append(progressCell)
            $(table).append(row);
            $("#wordPerformance").empty().append(table);
        }
    }
}

// Select and Deselect the row on word selection
$(document).on("click", "#displayWidgetsForSelectedWord", function (e) {
    var checkBoxIsChecked = $(this).is(':checked');
    var wordName = $(this).attr('data');

    if (checkBoxIsChecked) {
        $('input:checkbox').each(function () {
            this.checked = false;
            if ($('#wordPerformance tr').hasClass("green-color")) {
                $(this).closest('tr').removeClass("green-color");
            }
        });

        $("#wordsDropdownButton").prop('disabled', true);
        if ($(".display-selected-wordtopic").hasClass("visibility-hide")) {
            $(".display-selected-wordtopic").removeClass("visibility-hide");
            $(".display-selected-wordtopic").addClass("visibility-show");
        }
        $(this).prop('checked', true);
        $(this).closest('tr').addClass("green-color");
        $(".selected-word-topic").text(wordName);
        textHighlightDashboardResults.wordSearch = $(this).attr('data-id');
        getDataForWordPerformanceFilter();
    }
    else {
        if ($(".display-selected-wordtopic").hasClass("visibility-show")) {
            $(".display-selected-wordtopic").removeClass("visibility-show");
            $(".display-selected-wordtopic").addClass("visibility-hide");
        }
        clearSelectedWordsFilter();
    }
});

// Load Highlight performance and Comments widget on word selection 
function getDataForWordPerformanceFilter() {
    searchWords();
    a4.callServerMethod(a4.getSurveyAction("GetDataForWordPerformanceFilter", "TextHighlighter"), {
        questionId: selectedQuestionId, wordSearch: textHighlightDashboardResults.wordSearch
    }, function (response) {
        renderTextHighlightsPerformanceWidget(response.TextHighlightPerformanceList);
        renderTextHighlightsCommentsWidget();
    });
}

// Clear the selected word filter
function clearSelectedWordsFilter() {
    $('input:checkbox').each(function () {
        this.checked = false;
        if ($('#wordPerformance tr').hasClass("green-color")) {
            $(this).closest('tr').removeClass("green-color");
        }
    });

    $("#wordsDropdownButton").prop('disabled', false);
    textHighlightDashboardResults.wordSearch = "";
    getDataForWordPerformanceFilter();
}

function getTopicType(frequencyCount) {
    var frequencyLabel = resources.Rare;
    var iconClass = "fa fa-moon-o";

    if (frequencyCount > 20) {
        frequencyLabel = resources.Popular;
        iconClass = "fa fa-fire";
    }
    else if (frequencyCount > 10) {
        frequencyLabel = resources.Frequent;
        iconClass = "fa fa-sun-o";
    }
    else if (frequencyCount > 5) {
        iconClass = "fa fa-bolt";
        frequencyLabel = resources.Common;
    }

    var iconAndLabel = '<i class=\'frequency-icon ' + iconClass + '\'></i><span> ' + frequencyLabel + ' <span class=\'word-frequency-count\'>(' + frequencyCount + ')</span></span>';
    return iconAndLabel;
}

function searchWordEvent() {
    var inElement = document.getElementById("wordsSearch");
    if (inElement)
        inElement.addEventListener("keypress", function (event) {
            if (event.keyCode === 13) {
                event.preventDefault();
                searchWords();
            }
        });
}

function searchWords() {
    var input = document.getElementById("wordsSearch");
    var filter = input.value.toUpperCase();
    var table = document.getElementById("wordPerformance");
    var tr = table.getElementsByTagName("tr");
   
    var isRowSelected = $('#wordPerformance tr #displayWidgetsForSelectedWord').is(':checked');
    if (isSearchWordsText === true && filter === "" && isRowSelected === false) {
        if (document.getElementById('chkMorePopular').checked) {
            var orderBy = $("#chkMorePopular").attr("data-id");
            setOrderForWordPerformanceData(orderBy, originalWordPerformanceData)
        } else {
            var orderBy = $("#chkLessPopular").attr("data-id");
            setOrderForWordPerformanceData(orderBy, originalWordPerformanceData)
        }
        isSearchWordsText = false;
    }

    wordPerformanceFilter = [];
    for (i = 0; i < tr.length; i++) {
        td = tr[i].getElementsByClassName("word-name")[0];
        if (td) {
            txtValue = td.textContent || td.innerText;
            if (txtValue.toUpperCase().indexOf(filter) > -1) {
                if (filter !== "") {
                    getWordPerformanceSearchData(txtValue);
                    isSearchWordsText = true;
                }
                tr[i].style.display = "";
            } else {
                tr[i].style.display = "none";
            }
        }
    }
}

function getWordPerformanceSearchData(searchText) {
    var wordFilterData = wordPerformanceBackup.filter(function (element) {
        return element.Words == searchText;
    });

    if (wordFilterData != null && wordFilterData.length > 0) {
        for (var index = 0; index < wordFilterData.length; index++) {

            var categoryDataList = [];
            if (wordFilterData[index].TextHighlightWordPerformanceDataList.length > 0) {
                $.each(wordFilterData[index].TextHighlightWordPerformanceDataList, function () {
                    var categoryModel = {
                        CategoryName: this.CategoryName,
                        CategoryColor: this.CategoryColor,
                        CategoryCount: this.CategoryCount,
                        RpsContent: this.RpsContent
                    };
                    categoryDataList.push(categoryModel);
                });
            }

            var wordsFinalModel = {
                Words: wordFilterData[index].Words,
                TotalHighlightsCounts: wordFilterData[index].TotalHighlightsCounts,
                TextHighlightWordPerformanceDataList: categoryDataList
            };
            wordPerformanceFilter.push(wordsFinalModel);
        }
    }
}

$(document).on("click", "#wordsDropdownButton", function (e) {
    if ($(".word-dropdown").hasClass("word-dropdown-hide")) {
        $(".word-dropdown").removeClass("word-dropdown-hide");
        $(".word-dropdown").addClass("word-dropdown-show");
    } else {
        $(".word-dropdown").removeClass("word-dropdown-show");
        $(".word-dropdown").addClass("word-dropdown-hide");
    }
});

$(document).on("click", ".wordsOrderByRadioBtn", function (e) {
    var orderBy = $(this).attr("data-id");
    var textHighlightWords;
    if (isSearchWordsText) {
        textHighlightWords = wordPerformanceFilter;
        isSearchWordsText = true;
    } else {
        textHighlightWords = wordPerformanceBackup;
    }

    originalWordPerformanceData = wordPerformanceBackup;
    setOrderForWordPerformanceData(orderBy, textHighlightWords);
});

function setOrderForWordPerformanceData(orderBy, textHighlightWords) {
    a4.callServerMethod(a4.getSurveyAction("GetWordPerformanceDataOrderBy", "TextHighlighter"), {
        orderby: orderBy, textHighlightWords: textHighlightWords
    }, function (response) {
        renderTextHighlightsWordPerformanceWidget(response['TextHighlightWords']);
    });
}

$(document).click(function (e) {
    e.stopPropagation();
    var container = $(".dropdown");

    //check if the clicked area is dropDown or not
    if (container.has(e.target).length === 0) {
        $(".word-dropdown").addClass("word-dropdown-hide");
    }
});